/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzacraft.init;

import com.google.common.collect.Maps;
import com.tiviacz.pizzacraft.init.ModTags;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class PizzaLayers {
    public static final Map<TagKey<Item>, ResourceLocation> TAG_TO_LAYER = Maps.newHashMap();
    public static final Map<TagKey<Item>, ResourceLocation> TAG_TO_RAW_LAYER = Maps.newHashMap();
    public static final Map<TagKey<Item>, ResourceLocation> TAG_TO_ITEM_LAYER = Maps.newHashMap();
    public static final Map<TagKey<Item>, Integer> TAG_TO_MAX_STACK_SIZE = Maps.newHashMap();
    public static final ResourceLocation PIZZA_SLICE = new ResourceLocation("pizzacraft", "item/pizza_slice");
    public static final ResourceLocation CHEESE_LAYER = new ResourceLocation("pizzacraft", "block/cheese_layer");
    public static final ResourceLocation RAW_CHEESE_LAYER = new ResourceLocation("pizzacraft", "block/raw_cheese_layer");
    public static final ResourceLocation BROCCOLI_LAYER = new ResourceLocation("pizzacraft", "block/broccoli_layer");
    public static final ResourceLocation CORN_LAYER = new ResourceLocation("pizzacraft", "block/corn_layer");
    public static final ResourceLocation CUCUMBER_LAYER = new ResourceLocation("pizzacraft", "block/cucumber_layer");
    public static final ResourceLocation ONION_LAYER = new ResourceLocation("pizzacraft", "block/onion_layer");
    public static final ResourceLocation PEPPER_LAYER = new ResourceLocation("pizzacraft", "block/pepper_layer");
    public static final ResourceLocation TOMATO_LAYER = new ResourceLocation("pizzacraft", "block/tomato_layer");
    public static final ResourceLocation RAW_BROCCOLI_LAYER = new ResourceLocation("pizzacraft", "block/raw_broccoli_layer");
    public static final ResourceLocation RAW_CORN_LAYER = new ResourceLocation("pizzacraft", "block/raw_corn_layer");
    public static final ResourceLocation RAW_CUCUMBER_LAYER = new ResourceLocation("pizzacraft", "block/raw_cucumber_layer");
    public static final ResourceLocation RAW_ONION_LAYER = new ResourceLocation("pizzacraft", "block/raw_onion_layer");
    public static final ResourceLocation RAW_PEPPER_LAYER = new ResourceLocation("pizzacraft", "block/raw_pepper_layer");
    public static final ResourceLocation RAW_TOMATO_LAYER = new ResourceLocation("pizzacraft", "block/raw_tomato_layer");
    public static final ResourceLocation BROCCOLI_ITEM_LAYER = new ResourceLocation("pizzacraft", "item/broccoli_item_layer");
    public static final ResourceLocation CORN_ITEM_LAYER = new ResourceLocation("pizzacraft", "item/corn_item_layer");
    public static final ResourceLocation CUCUMBER_ITEM_LAYER = new ResourceLocation("pizzacraft", "item/cucumber_item_layer");
    public static final ResourceLocation ONION_ITEM_LAYER = new ResourceLocation("pizzacraft", "item/onion_item_layer");
    public static final ResourceLocation PEPPER_ITEM_LAYER = new ResourceLocation("pizzacraft", "item/pepper_item_layer");
    public static final ResourceLocation TOMATO_ITEM_LAYER = new ResourceLocation("pizzacraft", "item/tomato_item_layer");
    public static final ResourceLocation PINEAPPLE_LAYER = new ResourceLocation("pizzacraft", "block/pineapple_layer");
    public static final ResourceLocation OLIVE_LAYER = new ResourceLocation("pizzacraft", "block/olive_layer");
    public static final ResourceLocation RAW_PINEAPPLE_LAYER = new ResourceLocation("pizzacraft", "block/raw_pineapple_layer");
    public static final ResourceLocation RAW_OLIVE_LAYER = new ResourceLocation("pizzacraft", "block/raw_olive_layer");
    public static final ResourceLocation PINEAPPLE_ITEM_LAYER = new ResourceLocation("pizzacraft", "item/pineapple_item_layer");
    public static final ResourceLocation OLIVE_ITEM_LAYER = new ResourceLocation("pizzacraft", "item/olive_item_layer");
    public static final ResourceLocation MUSHROOM_LAYER = new ResourceLocation("pizzacraft", "block/mushroom_layer");
    public static final ResourceLocation RAW_MUSHROOM_LAYER = new ResourceLocation("pizzacraft", "block/raw_mushroom_layer");
    public static final ResourceLocation MUSHROOM_ITEM_LAYER = new ResourceLocation("pizzacraft", "item/mushroom_item_layer");
    public static final ResourceLocation HAM_LAYER = new ResourceLocation("pizzacraft", "block/ham_layer");
    public static final ResourceLocation BEEF_LAYER = new ResourceLocation("pizzacraft", "block/beef_layer");
    public static final ResourceLocation CHICKEN_LAYER = new ResourceLocation("pizzacraft", "block/chicken_layer");
    public static final ResourceLocation RAW_HAM_LAYER = new ResourceLocation("pizzacraft", "block/raw_ham_layer");
    public static final ResourceLocation RAW_BEEF_LAYER = new ResourceLocation("pizzacraft", "block/raw_beef_layer");
    public static final ResourceLocation RAW_CHICKEN_LAYER = new ResourceLocation("pizzacraft", "block/raw_chicken_layer");
    public static final ResourceLocation HAM_ITEM_LAYER = new ResourceLocation("pizzacraft", "item/ham_item_layer");
    public static final ResourceLocation BEEF_ITEM_LAYER = new ResourceLocation("pizzacraft", "item/beef_item_layer");
    public static final ResourceLocation CHICKEN_ITEM_LAYER = new ResourceLocation("pizzacraft", "item/chicken_item_layer");
    public static final ResourceLocation TOMATO_SAUCE_LAYER = new ResourceLocation("pizzacraft", "block/tomato_sauce_layer");
    public static final ResourceLocation TOMATO_SAUCE_ITEM_LAYER = new ResourceLocation("pizzacraft", "item/tomato_sauce_item_layer");
    public static final List<TagKey<Item>> VALID_TAGS = Arrays.asList(ModTags.CHEESE_LAYER, ModTags.BROCCOLI_LAYER, ModTags.CORN_LAYER, ModTags.CUCUMBER_LAYER, ModTags.ONION_LAYER, ModTags.PEPPER_LAYER, ModTags.TOMATO_LAYER, ModTags.PINEAPPLE_LAYER, ModTags.OLIVE_LAYER, ModTags.MUSHROOM_LAYER, ModTags.HAM_LAYER, ModTags.CHICKEN_LAYER, ModTags.TOMATO_SAUCE);
    public static final List<TagKey<Item>> VALID_ITEM_TAGS = Arrays.asList(ModTags.BROCCOLI_LAYER, ModTags.CORN_LAYER, ModTags.CUCUMBER_LAYER, ModTags.ONION_LAYER, ModTags.PEPPER_LAYER, ModTags.TOMATO_LAYER, ModTags.PINEAPPLE_LAYER, ModTags.OLIVE_LAYER, ModTags.MUSHROOM_LAYER, ModTags.HAM_LAYER, ModTags.CHICKEN_LAYER, ModTags.TOMATO_SAUCE);

    public static Map<TagKey<Item>, ResourceLocation> getTagToLayer() {
        return TAG_TO_LAYER;
    }

    public static Map<TagKey<Item>, ResourceLocation> getTagToRawLayer() {
        return TAG_TO_RAW_LAYER;
    }

    public static Map<TagKey<Item>, ResourceLocation> getTagToItemLayer() {
        return TAG_TO_ITEM_LAYER;
    }

    public static Map<TagKey<Item>, Integer> getTagToMaxStackSize() {
        return TAG_TO_MAX_STACK_SIZE;
    }

    public static int getMaxStackSizeForStack(ItemStack stack) {
        List tags = stack.m_204131_().toList();
        for (TagKey tag : tags) {
            if (!VALID_TAGS.contains(tag)) continue;
            return PizzaLayers.getTagToMaxStackSize().get(tag);
        }
        return 0;
    }

    public static void setMaps() {
        PizzaLayers.setTagToLayerMap();
        PizzaLayers.setTagToRawLayerMap();
        PizzaLayers.setTagToItemLayer();
        PizzaLayers.setTagToMaxStackSize();
    }

    public static void setTagToLayerMap() {
        TAG_TO_LAYER.put(ModTags.CHEESE_LAYER, CHEESE_LAYER);
        TAG_TO_LAYER.put(ModTags.BROCCOLI_LAYER, BROCCOLI_LAYER);
        TAG_TO_LAYER.put(ModTags.CORN_LAYER, CORN_LAYER);
        TAG_TO_LAYER.put(ModTags.CUCUMBER_LAYER, CUCUMBER_LAYER);
        TAG_TO_LAYER.put(ModTags.ONION_LAYER, ONION_LAYER);
        TAG_TO_LAYER.put(ModTags.PEPPER_LAYER, PEPPER_LAYER);
        TAG_TO_LAYER.put(ModTags.TOMATO_LAYER, TOMATO_LAYER);
        TAG_TO_LAYER.put(ModTags.PINEAPPLE_LAYER, PINEAPPLE_LAYER);
        TAG_TO_LAYER.put(ModTags.OLIVE_LAYER, OLIVE_LAYER);
        TAG_TO_LAYER.put(ModTags.MUSHROOM_LAYER, MUSHROOM_LAYER);
        TAG_TO_LAYER.put(ModTags.HAM_LAYER, HAM_LAYER);
        TAG_TO_LAYER.put(ModTags.CHICKEN_LAYER, CHICKEN_LAYER);
        TAG_TO_LAYER.put(ModTags.TOMATO_SAUCE, TOMATO_SAUCE_LAYER);
    }

    public static void setTagToRawLayerMap() {
        TAG_TO_RAW_LAYER.put(ModTags.CHEESE_LAYER, RAW_CHEESE_LAYER);
        TAG_TO_RAW_LAYER.put(ModTags.BROCCOLI_LAYER, RAW_BROCCOLI_LAYER);
        TAG_TO_RAW_LAYER.put(ModTags.CORN_LAYER, RAW_CORN_LAYER);
        TAG_TO_RAW_LAYER.put(ModTags.CUCUMBER_LAYER, RAW_CUCUMBER_LAYER);
        TAG_TO_RAW_LAYER.put(ModTags.ONION_LAYER, RAW_ONION_LAYER);
        TAG_TO_RAW_LAYER.put(ModTags.PEPPER_LAYER, RAW_PEPPER_LAYER);
        TAG_TO_RAW_LAYER.put(ModTags.TOMATO_LAYER, RAW_TOMATO_LAYER);
        TAG_TO_RAW_LAYER.put(ModTags.PINEAPPLE_LAYER, RAW_PINEAPPLE_LAYER);
        TAG_TO_RAW_LAYER.put(ModTags.OLIVE_LAYER, RAW_OLIVE_LAYER);
        TAG_TO_RAW_LAYER.put(ModTags.MUSHROOM_LAYER, RAW_MUSHROOM_LAYER);
        TAG_TO_RAW_LAYER.put(ModTags.HAM_LAYER, RAW_HAM_LAYER);
        TAG_TO_RAW_LAYER.put(ModTags.CHICKEN_LAYER, RAW_CHICKEN_LAYER);
        TAG_TO_RAW_LAYER.put(ModTags.TOMATO_SAUCE, TOMATO_SAUCE_LAYER);
    }

    public static void setTagToItemLayer() {
        TAG_TO_ITEM_LAYER.put(ModTags.BROCCOLI_LAYER, BROCCOLI_ITEM_LAYER);
        TAG_TO_ITEM_LAYER.put(ModTags.CORN_LAYER, CORN_ITEM_LAYER);
        TAG_TO_ITEM_LAYER.put(ModTags.CUCUMBER_LAYER, CUCUMBER_ITEM_LAYER);
        TAG_TO_ITEM_LAYER.put(ModTags.ONION_LAYER, ONION_ITEM_LAYER);
        TAG_TO_ITEM_LAYER.put(ModTags.PEPPER_LAYER, PEPPER_ITEM_LAYER);
        TAG_TO_ITEM_LAYER.put(ModTags.TOMATO_LAYER, TOMATO_ITEM_LAYER);
        TAG_TO_ITEM_LAYER.put(ModTags.PINEAPPLE_LAYER, PINEAPPLE_ITEM_LAYER);
        TAG_TO_ITEM_LAYER.put(ModTags.OLIVE_LAYER, OLIVE_ITEM_LAYER);
        TAG_TO_ITEM_LAYER.put(ModTags.MUSHROOM_LAYER, MUSHROOM_ITEM_LAYER);
        TAG_TO_ITEM_LAYER.put(ModTags.HAM_LAYER, HAM_ITEM_LAYER);
        TAG_TO_ITEM_LAYER.put(ModTags.CHICKEN_LAYER, CHICKEN_ITEM_LAYER);
        TAG_TO_ITEM_LAYER.put(ModTags.TOMATO_SAUCE, TOMATO_SAUCE_ITEM_LAYER);
    }

    public static void setTagToMaxStackSize() {
        TAG_TO_MAX_STACK_SIZE.put(ModTags.CHEESE_LAYER, 1);
        TAG_TO_MAX_STACK_SIZE.put(ModTags.BROCCOLI_LAYER, 2);
        TAG_TO_MAX_STACK_SIZE.put(ModTags.CORN_LAYER, 2);
        TAG_TO_MAX_STACK_SIZE.put(ModTags.CUCUMBER_LAYER, 4);
        TAG_TO_MAX_STACK_SIZE.put(ModTags.ONION_LAYER, 4);
        TAG_TO_MAX_STACK_SIZE.put(ModTags.PEPPER_LAYER, 4);
        TAG_TO_MAX_STACK_SIZE.put(ModTags.TOMATO_LAYER, 4);
        TAG_TO_MAX_STACK_SIZE.put(ModTags.PINEAPPLE_LAYER, 4);
        TAG_TO_MAX_STACK_SIZE.put(ModTags.OLIVE_LAYER, 4);
        TAG_TO_MAX_STACK_SIZE.put(ModTags.MUSHROOM_LAYER, 4);
        TAG_TO_MAX_STACK_SIZE.put(ModTags.HAM_LAYER, 4);
        TAG_TO_MAX_STACK_SIZE.put(ModTags.CHICKEN_LAYER, 4);
        TAG_TO_MAX_STACK_SIZE.put(ModTags.TOMATO_SAUCE, 1);
    }

    public static ResourceLocation createResourceLocation(String tagName) {
        return new ResourceLocation("pizzacraft", tagName);
    }

    public static void setMaxStackSizeMap() {
    }
}

